import Element from '../element/Element.cjs';
import * as PropertySymbol from '../../PropertySymbol.cjs';
import BrowserWindow from '../../window/BrowserWindow.cjs';
import Node from '../node/Node.cjs';
import NodeIterator from '../../tree-walker/NodeIterator.cjs';
import TreeWalker from '../../tree-walker/TreeWalker.cjs';
import DocumentFragment from '../document-fragment/DocumentFragment.cjs';
import Event from '../../event/Event.cjs';
import DOMImplementation from '../../dom-implementation/DOMImplementation.cjs';
import INodeFilter from '../../tree-walker/INodeFilter.cjs';
import DocumentType from '../document-type/DocumentType.cjs';
import CSSStyleSheet from '../../css/CSSStyleSheet.cjs';
import HTMLScriptElement from '../html-script-element/HTMLScriptElement.cjs';
import HTMLElement from '../html-element/HTMLElement.cjs';
import Comment from '../comment/Comment.cjs';
import Text from '../text/Text.cjs';
import NodeList from '../node/NodeList.cjs';
import HTMLCollection from '../element/HTMLCollection.cjs';
import DocumentReadyStateEnum from './DocumentReadyStateEnum.cjs';
import Location from '../../location/Location.cjs';
import Selection from '../../selection/Selection.cjs';
import Range from '../../range/Range.cjs';
import Attr from '../attr/Attr.cjs';
import ProcessingInstruction from '../processing-instruction/ProcessingInstruction.cjs';
import VisibilityStateEnum from './VisibilityStateEnum.cjs';
import NodeTypeEnum from '../node/NodeTypeEnum.cjs';
import IHTMLElementTagNameMap from '../../config/IHTMLElementTagNameMap.cjs';
import ISVGElementTagNameMap from '../../config/ISVGElementTagNameMap.cjs';
import SVGElement from '../svg-element/SVGElement.cjs';
import HTMLFormElement from '../html-form-element/HTMLFormElement.cjs';
import HTMLAnchorElement from '../html-anchor-element/HTMLAnchorElement.cjs';
import HTMLHtmlElement from '../html-html-element/HTMLHtmlElement.cjs';
import HTMLBodyElement from '../html-body-element/HTMLBodyElement.cjs';
import HTMLHeadElement from '../html-head-element/HTMLHeadElement.cjs';
import ICachedResult from '../node/ICachedResult.cjs';
/**
 * Document.
 */
export default class Document extends Node {
    #private;
    [PropertySymbol.children]: HTMLCollection<Element> | null;
    [PropertySymbol.activeElement]: HTMLElement | SVGElement;
    [PropertySymbol.nextActiveElement]: HTMLElement | SVGElement;
    [PropertySymbol.currentScript]: HTMLScriptElement;
    [PropertySymbol.rootNode]: this;
    [PropertySymbol.isFirstWrite]: boolean;
    [PropertySymbol.isFirstWriteAfterOpen]: boolean;
    [PropertySymbol.nodeType]: NodeTypeEnum;
    [PropertySymbol.isConnected]: boolean;
    [PropertySymbol.adoptedStyleSheets]: CSSStyleSheet[];
    [PropertySymbol.implementation]: DOMImplementation;
    [PropertySymbol.readyState]: DocumentReadyStateEnum;
    [PropertySymbol.referrer]: string;
    [PropertySymbol.defaultView]: BrowserWindow | null;
    [PropertySymbol.forms]: HTMLCollection<HTMLFormElement> | null;
    [PropertySymbol.affectsComputedStyleCache]: ICachedResult[];
    [PropertySymbol.ownerDocument]: Document;
    [PropertySymbol.elementIdMap]: Map<string, {
        htmlCollection: HTMLCollection<Element> | null;
        elements: Element[];
    }>;
    cloneNode: (deep?: boolean) => Document;
    onreadystatechange: (event: Event) => void;
    onpointerlockchange: (event: Event) => void;
    onpointerlockerror: (event: Event) => void;
    onbeforecopy: (event: Event) => void;
    onbeforecut: (event: Event) => void;
    onbeforepaste: (event: Event) => void;
    onfreeze: (event: Event) => void;
    onresume: (event: Event) => void;
    onsearch: (event: Event) => void;
    onvisibilitychange: (event: Event) => void;
    onfullscreenchange: (event: Event) => void;
    onfullscreenerror: (event: Event) => void;
    onwebkitfullscreenchange: (event: Event) => void;
    onwebkitfullscreenerror: (event: Event) => void;
    onbeforexrselect: (event: Event) => void;
    onabort: (event: Event) => void;
    onbeforeinput: (event: Event) => void;
    onblur: (event: Event) => void;
    oncancel: (event: Event) => void;
    oncanplay: (event: Event) => void;
    oncanplaythrough: (event: Event) => void;
    onchange: (event: Event) => void;
    onclick: (event: Event) => void;
    onclose: (event: Event) => void;
    oncontextlost: (event: Event) => void;
    oncontextmenu: (event: Event) => void;
    oncontextrestored: (event: Event) => void;
    oncuechange: (event: Event) => void;
    ondblclick: (event: Event) => void;
    ondrag: (event: Event) => void;
    ondragend: (event: Event) => void;
    ondragenter: (event: Event) => void;
    ondragleave: (event: Event) => void;
    ondragover: (event: Event) => void;
    ondragstart: (event: Event) => void;
    ondrop: (event: Event) => void;
    ondurationchange: (event: Event) => void;
    onemptied: (event: Event) => void;
    onended: (event: Event) => void;
    onerror: (event: Event) => void;
    onfocus: (event: Event) => void;
    onformdata: (event: Event) => void;
    oninput: (event: Event) => void;
    oninvalid: (event: Event) => void;
    onkeydown: (event: Event) => void;
    onkeypress: (event: Event) => void;
    onkeyup: (event: Event) => void;
    onload: (event: Event) => void;
    onloadeddata: (event: Event) => void;
    onloadedmetadata: (event: Event) => void;
    onloadstart: (event: Event) => void;
    onmousedown: (event: Event) => void;
    onmouseenter: (event: Event) => void;
    onmouseleave: (event: Event) => void;
    onmousemove: (event: Event) => void;
    onmouseout: (event: Event) => void;
    onmouseover: (event: Event) => void;
    onmouseup: (event: Event) => void;
    onmousewheel: (event: Event) => void;
    onpause: (event: Event) => void;
    onplay: (event: Event) => void;
    onplaying: (event: Event) => void;
    onprogress: (event: Event) => void;
    onratechange: (event: Event) => void;
    onreset: (event: Event) => void;
    onresize: (event: Event) => void;
    onscroll: (event: Event) => void;
    onsecuritypolicyviolation: (event: Event) => void;
    onseeked: (event: Event) => void;
    onseeking: (event: Event) => void;
    onselect: (event: Event) => void;
    onslotchange: (event: Event) => void;
    onstalled: (event: Event) => void;
    onsubmit: (event: Event) => void;
    onsuspend: (event: Event) => void;
    ontimeupdate: (event: Event) => void;
    ontoggle: (event: Event) => void;
    onvolumechange: (event: Event) => void;
    onwaiting: (event: Event) => void;
    onwebkitanimationend: (event: Event) => void;
    onwebkitanimationiteration: (event: Event) => void;
    onwebkitanimationstart: (event: Event) => void;
    onwebkittransitionend: (event: Event) => void;
    onwheel: (event: Event) => void;
    onauxclick: (event: Event) => void;
    ongotpointercapture: (event: Event) => void;
    onlostpointercapture: (event: Event) => void;
    onpointerdown: (event: Event) => void;
    onpointermove: (event: Event) => void;
    onpointerrawupdate: (event: Event) => void;
    onpointerup: (event: Event) => void;
    onpointercancel: (event: Event) => void;
    onpointerover: (event: Event) => void;
    onpointerout: (event: Event) => void;
    onpointerenter: (event: Event) => void;
    onpointerleave: (event: Event) => void;
    onselectstart: (event: Event) => void;
    onselectionchange: (event: Event) => void;
    onanimationend: (event: Event) => void;
    onanimationiteration: (event: Event) => void;
    onanimationstart: (event: Event) => void;
    ontransitionrun: (event: Event) => void;
    ontransitionstart: (event: Event) => void;
    ontransitionend: (event: Event) => void;
    ontransitioncancel: (event: Event) => void;
    oncopy: (event: Event) => void;
    oncut: (event: Event) => void;
    onpaste: (event: Event) => void;
    onbeforematch: (event: Event) => void;
    /**
     * Returns adopted style sheets.
     *
     * @returns Adopted style sheets.
     */
    get adoptedStyleSheets(): CSSStyleSheet[];
    /**
     * Sets adopted style sheets.
     *
     * @param value Adopted style sheets.
     */
    set adoptedStyleSheets(value: CSSStyleSheet[]);
    /**
     * Returns DOM implementation.
     *
     * @returns DOM implementation.
     */
    get implementation(): DOMImplementation;
    /**
     * Returns document ready state.
     *
     * @returns Document ready state.
     */
    get readyState(): DocumentReadyStateEnum;
    /**
     * Returns referrer.
     *
     * @returns Referrer.
     */
    get referrer(): string;
    /**
     * Returns default view.
     *
     * @returns Default view.
     */
    get defaultView(): BrowserWindow | null;
    /**
     * Returns document children.
     */
    get children(): HTMLCollection<Element>;
    /**
     * Returns character set.
     *
     * @deprecated
     * @returns Character set.
     */
    get charset(): string;
    /**
     * Returns character set.
     *
     * @returns Character set.
     */
    get characterSet(): string;
    /**
     * Returns title.
     *
     * @returns Title.
     */
    get title(): string;
    /**
     * Returns set title.
     *
     */
    set title(title: string);
    /**
     * Returns a collection of all area elements and a elements in a document with a value for the href attribute.
     */
    get links(): NodeList<HTMLAnchorElement | HTMLElement>;
    /**
     * Returns a collection of all form elements in a document.
     */
    get forms(): HTMLCollection<HTMLFormElement>;
    /**
     * Last element child.
     *
     * @returns Element.
     */
    get childElementCount(): number;
    /**
     * First element child.
     *
     * @returns Element.
     */
    get firstElementChild(): Element;
    /**
     * Last element child.
     *
     * @returns Element.
     */
    get lastElementChild(): Element;
    /**
     * Returns cookie string.
     *
     * @returns Cookie.
     */
    get cookie(): string;
    /**
     * Sets a cookie string.
     *
     * @param cookie Cookie string.
     */
    set cookie(cookie: string);
    /**
     * Node name.
     *
     * @returns Node name.
     */
    get nodeName(): string;
    /**
     * Returns <html> element.
     *
     * @returns Element.
     */
    get documentElement(): HTMLHtmlElement;
    /**
     * Returns document type element.
     *
     * @returns Document type.
     */
    get doctype(): DocumentType;
    /**
     * Returns <body> element.
     *
     * @returns Element.
     */
    get body(): HTMLBodyElement;
    /**
     * Returns <head> element.
     *
     * @returns Element.
     */
    get head(): HTMLHeadElement;
    /**
     * Returns CSS style sheets.
     *
     * @returns CSS style sheets.
     */
    get styleSheets(): CSSStyleSheet[];
    /**
     * Returns active element.
     *
     * @returns Active element.
     */
    get activeElement(): HTMLElement | SVGElement;
    /**
     * Returns scrolling element.
     *
     * @returns Scrolling element.
     */
    get scrollingElement(): HTMLElement;
    /**
     * Returns location.
     *
     * @returns Location.
     */
    get location(): Location;
    /**
     * Returns scripts.
     *
     * @returns Scripts.
     */
    get scripts(): HTMLCollection<HTMLScriptElement>;
    /**
     * Returns base URI.
     *
     * @override
     * @returns Base URI.
     */
    get baseURI(): string;
    /**
     * Returns URL.
     *
     * @returns URL of the current document.
     * */
    get URL(): string;
    /**
     * Returns document URI.
     *
     * @returns URL of the current document.
     * */
    get documentURI(): string;
    /**
     * Returns domain.
     *
     * @returns Domain.
     * */
    get domain(): string;
    /**
     * Returns document visibility state.
     *
     * @returns the visibility state of the current document.
     * */
    get visibilityState(): VisibilityStateEnum;
    /**
     * Returns document hidden state.
     *
     * @returns the hidden state of the current document.
     * */
    get hidden(): boolean;
    /**
     * Gets the currently executing script element.
     *
     * @returns the currently executing script element.
     */
    get currentScript(): HTMLScriptElement;
    /**
     * Inserts a set of Node objects or DOMString objects after the last child of the ParentNode. DOMString objects are inserted as equivalent Text nodes.
     *
     * @param nodes List of Node or DOMString.
     */
    append(...nodes: (Node | string)[]): void;
    /**
     * Inserts a set of Node objects or DOMString objects before the first child of the ParentNode. DOMString objects are inserted as equivalent Text nodes.
     *
     * @param nodes List of Node or DOMString.
     */
    prepend(...nodes: (Node | string)[]): void;
    /**
     * Replaces the existing children of a node with a specified new set of children.
     *
     * @param nodes List of Node or DOMString.
     */
    replaceChildren(...nodes: (Node | string)[]): void;
    /**
     * Query CSS selector to find matching nodes.
     *
     * @param selector CSS selector.
     * @returns Matching elements.
     */
    querySelectorAll<K extends keyof IHTMLElementTagNameMap>(selector: K): NodeList<IHTMLElementTagNameMap[K]>;
    /**
     * Query CSS selector to find matching elments.
     *
     * @param selector CSS selector.
     * @returns Matching elements.
     */
    querySelectorAll<K extends keyof ISVGElementTagNameMap>(selector: K): NodeList<ISVGElementTagNameMap[K]>;
    /**
     * Query CSS selector to find matching elments.
     *
     * @param selector CSS selector.
     * @returns Matching elements.
     */
    querySelectorAll(selector: string): NodeList<Element>;
    /**
     * Query CSS Selector to find matching node.
     *
     * @param selector CSS selector.
     * @returns Matching element.
     */
    querySelector<K extends keyof IHTMLElementTagNameMap>(selector: K): IHTMLElementTagNameMap[K] | null;
    /**
     * Query CSS Selector to find matching node.
     *
     * @param selector CSS selector.
     * @returns Matching element.
     */
    querySelector<K extends keyof ISVGElementTagNameMap>(selector: K): ISVGElementTagNameMap[K] | null;
    /**
     * Query CSS Selector to find matching node.
     *
     * @param selector CSS selector.
     * @returns Matching element.
     */
    querySelector(selector: string): Element | null;
    /**
     * Returns true if the command is supported.
     * @deprecated
     * @param _ Command.
     * @returns True if the command is supported, false otherwise.
     */
    queryCommandSupported(_: string): boolean;
    /**
     * Returns an elements by class name.
     *
     * @param className Tag name.
     * @returns Matching element.
     */
    getElementsByClassName(className: string): HTMLCollection<Element>;
    /**
     * Returns an elements by tag name.
     *
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagName<K extends keyof IHTMLElementTagNameMap>(tagName: K): HTMLCollection<IHTMLElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name.
     *
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagName<K extends keyof ISVGElementTagNameMap>(tagName: K): HTMLCollection<ISVGElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name.
     *
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagName(tagName: string): HTMLCollection<Element>;
    /**
     * Returns an elements by tag name and namespace.
     *
     * @param namespaceURI Namespace URI.
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagNameNS<K extends keyof IHTMLElementTagNameMap>(namespaceURI: 'http://www.w3.org/1999/xhtml', tagName: K): HTMLCollection<IHTMLElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name and namespace.
     *
     * @param namespaceURI Namespace URI.
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagNameNS<K extends keyof ISVGElementTagNameMap>(namespaceURI: 'http://www.w3.org/2000/svg', tagName: K): HTMLCollection<ISVGElementTagNameMap[K]>;
    /**
     * Returns an elements by tag name and namespace.
     *
     * @param namespaceURI Namespace URI.
     * @param tagName Tag name.
     * @returns Matching element.
     */
    getElementsByTagNameNS(namespaceURI: string, tagName: string): HTMLCollection<Element>;
    /**
     * Returns an element by ID.
     *
     * @param id ID.
     * @returns Matching element.
     */
    getElementById(id: string): Element | null;
    /**
     * Returns an element by Name.
     *
     * @returns Matching element.
     * @param name
     */
    getElementsByName(name: string): NodeList<Element>;
    /**
     * Replaces the document HTML with new HTML.
     *
     * @param html HTML.
     */
    write(html: string): void;
    /**
     * Opens the document.
     *
     * @returns Document.
     */
    open(): Document;
    /**
     * Closes the document.
     */
    close(): void;
    /**
     * Creates an element.
     *
     * @param qualifiedName Tag name.
     * @param [options] Options.
     * @param [options.is] Tag name of a custom element previously defined via customElements.define().
     * @returns Element.
     */
    createElement<K extends keyof IHTMLElementTagNameMap>(qualifiedName: K, options?: {
        is?: string;
    }): IHTMLElementTagNameMap[K];
    /**
     * Creates an element.
     *
     * @param qualifiedName Tag name.
     * @param [options] Options.
     * @param [options.is] Tag name of a custom element previously defined via customElements.define().
     * @returns Element.
     */
    createElement<K extends keyof ISVGElementTagNameMap>(qualifiedName: K, options?: {
        is?: string;
    }): ISVGElementTagNameMap[K];
    /**
     * Creates an element.
     *
     * @param qualifiedName Tag name.
     * @param [options] Options.
     * @param [options.is] Tag name of a custom element previously defined via customElements.define().
     * @returns Element.
     */
    createElement(qualifiedName: string, options?: {
        is?: string;
    }): HTMLElement;
    /**
     * Creates an element with the specified namespace URI and qualified name.
     *
     * @param namespaceURI Namespace URI.
     * @param qualifiedName Tag name.
     * @param [options] Options.
     * @param [options.is] Tag name of a custom element previously defined via customElements.define().
     * @returns Element.
     */
    createElementNS<K extends keyof IHTMLElementTagNameMap>(namespaceURI: 'http://www.w3.org/1999/xhtml', qualifiedName: K, options?: {
        is?: string;
    }): IHTMLElementTagNameMap[K];
    /**
     * Creates an element with the specified namespace URI and qualified name.
     *
     * @param namespaceURI Namespace URI.
     * @param qualifiedName Tag name.
     * @param [options] Options.
     * @param [options.is] Tag name of a custom element previously defined via customElements.define().
     * @returns Element.
     */
    createElementNS<K extends keyof ISVGElementTagNameMap>(namespaceURI: 'http://www.w3.org/2000/svg', qualifiedName: K, options?: {
        is?: string;
    }): ISVGElementTagNameMap[K];
    /**
     * Creates an element with the specified namespace URI and qualified name.
     *
     * @param namespaceURI Namespace URI.
     * @param qualifiedName Tag name.
     * @param [options] Options.
     * @param [options.is] Tag name of a custom element previously defined via customElements.define().
     * @returns Element.
     */
    createElementNS(namespaceURI: string, qualifiedName: string, options?: {
        is?: string;
    }): Element;
    /**
     * Creates a text node.
     *
     * @param [data] Text data.
     * @returns Text node.
     */
    createTextNode(data: string): Text;
    /**
     * Creates a comment node.
     *
     * @param [data] Text data.
     * @returns Text node.
     */
    createComment(data?: string): Comment;
    /**
     * Creates a document fragment.
     *
     * @returns Document fragment.
     */
    createDocumentFragment(): DocumentFragment;
    /**
     * Creates a node iterator.
     *
     * @param root Root.
     * @param [whatToShow] What to show.
     * @param [filter] Filter.
     */
    createNodeIterator(root: Node, whatToShow?: number, filter?: INodeFilter): NodeIterator;
    /**
     * Creates a Tree Walker.
     *
     * @param root Root.
     * @param [whatToShow] What to show.
     * @param [filter] Filter.
     */
    createTreeWalker(root: Node, whatToShow?: number, filter?: INodeFilter): TreeWalker;
    /**
     * Creates an event.
     *
     * @deprecated
     * @param type Type.
     * @returns Event.
     */
    createEvent(type: string): Event;
    /**
     * Creates an Attr node.
     *
     * @param qualifiedName Name.
     * @returns Attribute.
     */
    createAttribute(qualifiedName: string): Attr;
    /**
     * Creates a namespaced Attr node.
     *
     * @param namespaceURI Namespace URI.
     * @param qualifiedName Qualified name.
     * @returns Element.
     */
    createAttributeNS(namespaceURI: string, qualifiedName: string): Attr;
    /**
     * Imports a node.
     *
     * @param node Node to import.
     * @param [deep=false] Set to "true" if the clone should be deep.
     */
    importNode(node: Node, deep?: boolean): Node;
    /**
     * Creates a range.
     *
     * @returns Range.
     */
    createRange(): Range;
    /**
     * Adopts a node.
     *
     * @param node Node to adopt.
     * @returns Adopted node.
     */
    adoptNode(node: Node): Node;
    /**
     * Returns selection.
     *
     * @returns Selection.
     */
    getSelection(): Selection;
    /**
     * Returns a boolean value indicating whether the document or any element inside the document has focus.
     *
     * @returns "true" if the document has focus.
     */
    hasFocus(): boolean;
    /**
     * Creates a Processing Instruction node.
     *
     * @param target Target.
     * @param data Data.
     * @returns ProcessingInstruction.
     */
    createProcessingInstruction(target: string, data: string): ProcessingInstruction;
    /**
     * Get element at a given point.
     *
     * @param _x horizontal coordinate
     * @param _y vertical coordinate
     * @returns Always returns null since Happy DOM does not render elements.
     */
    elementFromPoint(_x: number, _y: number): Element | null;
}
//# sourceMappingURL=Document.d.ts.map