"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const REDIRECT_STATUS_CODES = [301, 302, 303, 307, 308];
const MAX_REDIRECT_COUNT = 20;
/**
 * Fetch request validation utility.
 */
class FetchResponseRedirectUtility {
    /**
     * Returns "true" if redirect.
     *
     * @param statusCode Status code.
     * @returns "true" if redirect.
     */
    static isRedirect(statusCode) {
        return REDIRECT_STATUS_CODES.includes(statusCode);
    }
    /**
     * Returns "true" if max redirects is reached.
     *
     * @param redirectCount Redirect count.
     * @returns "true" if max redirects is reached.
     */
    static isMaxRedirectsReached(redirectCount) {
        return redirectCount >= MAX_REDIRECT_COUNT;
    }
}
exports.default = FetchResponseRedirectUtility;
//# sourceMappingURL=FetchResponseRedirectUtility.cjs.map