# Contributing to `auto-changelog`

Installing the library locally is relatively easy:

```bash
git clone https://github.com/CookPete/auto-changelog.git
cd auto-changelog
yarn # or npm install
```

You can then run it with simply:

```bash
node src/index.js
```

## Linting

This project uses [standard](https://github.com/feross/standard) code style. Be sure to lint the code after making changes and fix any issues that come up.

```bash
yarn lint # or npm run lint
```

## Testing

This project uses [mocha](https://github.com/mochajs/mocha) and [chai](https://github.com/chaijs/chai) for testing. Be sure to run tests after making changes and, if you’re feeling generous, add some tests of your own.

```bash
yarn test # or npm test
```

## Becoming a sponsor

A great way to show your appreciation and get an issue bumped to a higher priority is to [become a sponsor on Patreon](https://www.patreon.com/cookpete).
