export default [
    {
        destinations: [
            "vago-sympathetic trunk",
            "vagus nerve",
            "ventricular intrinsic cardiac ganglion",
            "medulla oblongata",
            "Atrial intrinsic cardiac ganglion",
        ],
        origins: ["nucleus ambiguus", "dorsal motor nucleus of vagus nerve"],
        components: ["epicardial fat, heart"],
        destinationsWithDatasets: [
            { id: "ILX:0793555", name: "Atrial intrinsic cardiac ganglion" },
            { id: "ILX:0793556", name: "ventricular intrinsic cardiac ganglion" },
            { id: "UBERON:0001759", name: "vagus nerve" },
            { id: "UBERON:0001896", name: "medulla oblongata" },
            { id: "ilxtr:vago-sympathetic-trunk", name: "vago-sympathetic trunk" },
        ],
        originsWithDatasets: [
            { id: "UBERON:0001719", name: "nucleus ambiguus" },
            { id: "UBERON:0002870", name: "dorsal motor nucleus of vagus nerve" },
        ],
        componentsWithDatasets: [
            { id: "UBERON:0000948", name: "heart" },
            { id: "UBERON:0015129", name: "epicardial fat" },
        ],
        title: "neuron type aacar 4",
        featureId: ["ilxtr:neuron-type-aacar-4"],
        hyperlinks: [],
        provenanceTaxonomy: ["NCBITaxon:9606", "NCBITaxon:9615", "NCBITaxon:9825"],
        provenanceTaxonomyLabel: [
            "Homo sapiens",
            "Canis lupus familiaris",
            "Domestic Pig",
        ],
        knowledgeSource: "sckan-2024-09-21-npo",
    },
    {
        destinations: [
            "Fifth thoracic ganglion",
            "ventricular intrinsic cardiac ganglion",
            "Sixth thoracic ganglion",
            "superior cervical ganglion",
            "T1 sympathetic ganglion",
            "Second thoracic ganglion",
            "Third thoracic ganglion",
            "mediastinal ganglion",
            "Fourth thoracic ganglion",
            "inferior cervical ganglion",
            "middle cervical ganglion",
            "Atrial intrinsic cardiac ganglion",
        ],
        origins: [
            "lamina VII of gray matter of spinal cord, first thoracic spinal cord segment",
            "lamina VII of gray matter of spinal cord, fourth thoracic spinal cord segment",
            "lamina VII of gray matter of spinal cord, sixth thoracic spinal cord segment",
            "lamina VII of gray matter of spinal cord, C8 segment of cervical spinal cord",
            "lamina VII of gray matter of spinal cord, third thoracic spinal cord segment",
            "lamina VII of gray matter of spinal cord, second thoracic spinal cord segment",
            "lamina VII of gray matter of spinal cord, fifth thoracic spinal cord segment",
        ],
        components: [
            "third thoracic spinal cord segment",
            "ansa subclavia",
            "T3 - T4 Interganglionic segment",
            "vago-sympathetic trunk",
            "T1 - T2 Interganglionic segment",
            "epicardial fat, heart",
            "White communicating ramus of sixth thoracic anterior ramus",
            "C8 segment of cervical spinal cord",
            "ventral nerve root of cervical spinal cord",
            "T2 - T3 Interganglionic segment",
            "Anterior root of third thoracic nerve",
            "White communicating ramus of third thoracic anterior ramus",
            "White communicating ramus of fourth thoracic anterior ramus",
            "Anterior root of sixth thoracic nerve",
            "Anterior root of fourth thoracic nerve",
            "fourth thoracic spinal cord segment",
            "Interganglionic branch of inferior cervical ganglion to vertebral ganglion",
            "T4 - T5 Interganglionic segment",
            "T5 - T6 Interganglionic segment",
            "second thoracic spinal cord segment",
            "Anterior root of second thoracic nerve",
            "fifth thoracic spinal cord segment",
            "Anterior root of fifth sacral nerve",
            "Interganglionic branch of inferior cervical ganglion to middle cervical ganglion",
            "sixth thoracic spinal cord segment",
            "Interganglionic branch of inferior cervical ganglion to first thoracic ganglion",
            "Anterior root of first thoracic nerve",
            "Anterior root of fifth thoracic nerve",
            "White communicating ramus of second thoracic anterior ramus",
            "White communicating ramus of fifth thoracic anterior ramus",
            "first thoracic spinal cord segment",
        ],
        destinationsWithDatasets: [
            {
                id: "ILX:0774266",
                name: "T1 sympathetic ganglion",
            },
            {
                id: "ILX:0786141",
                name: "Fifth thoracic ganglion",
            },
            {
                id: "ILX:0786228",
                name: "Second thoracic ganglion",
            },
            {
                id: "ILX:0786272",
                name: "Fourth thoracic ganglion",
            },
            {
                id: "ILX:0786722",
                name: "Third thoracic ganglion",
            },
            {
                id: "ILX:0789947",
                name: "Sixth thoracic ganglion",
            },
            {
                id: "ILX:0793550",
                name: "mediastinal ganglion",
            },
            {
                id: "ILX:0793555",
                name: "Atrial intrinsic cardiac ganglion",
            },
            {
                id: "ILX:0793556",
                name: "ventricular intrinsic cardiac ganglion",
            },
            {
                id: "UBERON:0001989",
                name: "superior cervical ganglion",
            },
            {
                id: "UBERON:0001990",
                name: "middle cervical ganglion",
            },
            {
                id: "UBERON:0002440",
                name: "inferior cervical ganglion",
            },
        ],
        originsWithDatasets: [
            {
                id: "UBERON:0006452",
                name: "fourth thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006453",
                name: "fifth thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006454",
                name: "sixth thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006457",
                name: "first thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006458",
                name: "second thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006459",
                name: "third thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006470",
                name: "C8 segment of cervical spinal cord",
            },
            {
                id: "UBERON:0016578",
                name: "lamina VII of gray matter of spinal cord",
            },
        ],
        componentsWithDatasets: [
            {
                id: "ILX:0739241",
                name: "ansa subclavia",
            },
            {
                id: "ILX:0777094",
                name: "T1 - T2 Interganglionic segment",
            },
            {
                id: "ILX:0777095",
                name: "T2 - T3 Interganglionic segment",
            },
            {
                id: "ILX:0777096",
                name: "T3 - T4 Interganglionic segment",
            },
            {
                id: "ILX:0777097",
                name: "T4 - T5 Interganglionic segment",
            },
            {
                id: "ILX:0777098",
                name: "T5 - T6 Interganglionic segment",
            },
            {
                id: "ILX:0784804",
                name: "Anterior root of third thoracic nerve",
            },
            {
                id: "ILX:0785971",
                name: "Anterior root of fifth sacral nerve",
            },
            {
                id: "ILX:0787722",
                name: "Anterior root of first thoracic nerve",
            },
            {
                id: "ILX:0789894",
                name: "Anterior root of second thoracic nerve",
            },
            {
                id: "ILX:0790146",
                name: "Anterior root of fifth thoracic nerve",
            },
            {
                id: "ILX:0791062",
                name: "Anterior root of sixth thoracic nerve",
            },
            {
                id: "ILX:0792838",
                name: "Anterior root of fourth thoracic nerve",
            },
            {
                id: "ILX:0793208",
                name: "White communicating ramus of second thoracic anterior ramus",
            },
            {
                id: "ILX:0793209",
                name: "White communicating ramus of third thoracic anterior ramus",
            },
            {
                id: "ILX:0793210",
                name: "White communicating ramus of fourth thoracic anterior ramus",
            },
            {
                id: "ILX:0793211",
                name: "White communicating ramus of fifth thoracic anterior ramus",
            },
            {
                id: "ILX:0793212",
                name: "White communicating ramus of sixth thoracic anterior ramus",
            },
            {
                id: "ILX:0793233",
                name: "Interganglionic branch of inferior cervical ganglion to first thoracic ganglion",
            },
            {
                id: "ILX:0793234",
                name: "Interganglionic branch of inferior cervical ganglion to middle cervical ganglion",
            },
            {
                id: "ILX:0793363",
                name: "Interganglionic branch of inferior cervical ganglion to vertebral ganglion",
            },
            {
                id: "UBERON:0000948",
                name: "heart",
            },
            {
                id: "UBERON:0006452",
                name: "fourth thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006453",
                name: "fifth thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006454",
                name: "sixth thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006457",
                name: "first thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006458",
                name: "second thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006459",
                name: "third thoracic spinal cord segment",
            },
            {
                id: "UBERON:0006470",
                name: "C8 segment of cervical spinal cord",
            },
            {
                id: "UBERON:0014634",
                name: "ventral nerve root of cervical spinal cord",
            },
            {
                id: "UBERON:0015129",
                name: "epicardial fat",
            },
            {
                id: "ilxtr:vago-sympathetic-trunk",
                name: "vago-sympathetic trunk",
            },
        ],
        title: "neuron type aacar 5",
        featureId: ["ilxtr:neuron-type-aacar-5"],
        hyperlinks: ["https://doi.org/10.1002/cphy.c150046"],
        provenanceTaxonomy: ["NCBITaxon:9606", "NCBITaxon:9615", "NCBITaxon:9825"],
        provenanceTaxonomyLabel: [
            "Homo sapiens",
            "Canis lupus familiaris",
            "Domestic Pig",
        ],
        "knowledge-source": "sckan-2024-03-26-npo",
    },
];
